%
%
%   Messen mit Setup aus csv-Datei
%   Datenspeicherung im Hintergrund
%   Aussteuerungsanzeige der Messkanle
%
%   Hochschule Mnchen
%   Labor fr Maschinendynmik
%   Dipl.-Ing. Armin Rohnen LbA
%
%   Mnchen, 21. Mai 2016
%
%   -----------------------------------------------------------------------

clear;

%
%   globale Variablen
%

%
%
%

[messgeraet, messung.fs, messung.messpunkt] = setup_from_file;

                    % SETUP
                    % Die Kanalbelegung muss in der Datei setuptabelle.csv
                    % abgelegt sein
                    % Abfolge:
                    % Geraet,Chan,Type,Name,Sensor,EU,Kalibrierwert,Unit,X,Y,Z
                    % die einzelnen Eintrge mssen mit "," getrennt sein
                    % als Dezimalzeichen ist ein "." erforderlich
                    % 
                    % Beispiel:
                    % Geraet,Chan,Type,Name,Sensor,EU,Kalibrierwert,Unit,X,Y,Z
                    % cDAQ3Mod1,ai0,IEPE,Bedplate X-Richtung,B&K 4504 SN 2032046 X,m/s^2,1.011914966,mV,0,0,0
                    %
                    % bernommen werden die Eintrge ab der Zeile zwei
                    %
%
% Dateinamen und Kommentar fr die Messung eingeben
%

str = input('Messbeschreibung: ','s');
while isempty(str)
    str = input('Messbeschreibung: ','s');
end;

messung.beschreibung = str;

str = input('Mess-Datei: ','s');
while isempty(str)
    str = input('Mess-Datei: ','s');
end;

save([str '.mat'], 'messung');                   % Konfiguration abespeichern
dataFile = fopen([str '.bin'], 'w');             % Datei fr die Messdaten

messgeraet.IsContinuous = true;                 % Messung kontinuierlich

levelHandle = levelmeter(messung);              % Aussteuerungsanzeige vorbereiten
status = 0;                                     % Status der Messung
                                                % 0 - Vorlauf
                                                % 1 - Messung
                                                % 2 - Messung beenden


messgeraet.NotifyWhenDataAvailableExceeds = ceil(messung.fs/3);
                                                 % Anzahl der Messwerte bis zum Auslsen des Event
                                                 % 'DataAvailable'
                                                 
dataListener = addlistener(messgeraet, 'DataAvailable', @(src, event)dispData(src, event, messung, levelHandle));
messgeraet.startBackground;

%
%
% -------------------------------------------------------------------------
%
%

changed = 0;

while status < 2
    number = input('neuer Status (1: Start, 2: Stop) :');
    status = number;
    
    if (status==1) && (changed == 0)
        changed = 1;
        delete(dataListener);
        dataListener = addlistener(messgeraet, 'DataAvailable', @(src, event)logData(src, event, messung, dataFile, levelHandle));
    end;
    
    if status == 2
        messgeraet.stop;
        fclose(dataFile);
        delete(dataListener);
    end;
end;