function [messgeraet, geraetetyp, fs, pre, df, messpunkt, schlagpunkt] = setup_mdynlab(hObject, eventdata, handles)
%-------------------------------------------------------------------------- 
% setup_mdynlab (Standardiesiertes Setup)
%-------------------------------------------------------------------------- 
% 
%     Dipl.-Ing. Armin Rohnen LbA
%     Labor fr Maschinendynamik
%     Hochschule fr angewandte Wissenschaften Mnchen
%     University of applied sciences Munich
% 
%     Mnchen, 02. Mai 2017
% 
% 
%     setup_mdynlab are free software you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation; either version 2, or (at your option)
%     any later version.
% 
%     setup_mdynlab are distributed in the hope that it will be useful, but
%     without any warranty; without even the implied warranty of
%     merchantability or fitness for a particular purpose. See the GNU
%     General Public License for more details.
% 
%     -----------------------------------------------------------------------
%     Funktionalitt:
% 
%     1.) Einlesen des Setups aus einer Datei. Der einzulesende Dateiname
%     ist in handles.meta.setupfile abgelegt. Die Datei muss eine CSV-Datei
%     mit ; als Trennzeichen sein. Dezimaltrennzeichen muss ein. (Punkt)
%     sein. Vorsicht bei der Verwendung von MS-Excel, dieses setzt ein ,
%     (Komma) als Dezimaltrennzeichen.
% 
%     2.) Aufbau der Datei In der zweiten Zeile werden feste Parameter
%     abgelegt. Diese sind (in dieser Reihenfolge) Messgerte-Typ (ni oder
%     au fr audio). Diese Angabe muss ein zwei Zeichen bestehen,
%     (Default)Abtasrate, (Default)Pretrigger und
%     (Default)Frequenzauflsung Ab der 4. Zeile kommen fr jeden Messkanal
%     eine Eingabezeile. In Spalte eins wird die Gertebezeichnung
%     eingetragen (Zeichenkette), Spalte zwei enthlt die Kanalbezeichnung
%     (Zeichenkette), Spalte drei den Messbereich in mV (Zahl), Spalte vier
%     enthlt die Kanalkonfiguration (Zeichenkette), in Spalte fnf wird
%     der Name des Messpunkts (Zeichenkette) eingetragen, Spalte sechs
%     enthlt Bezeichnung und Seriennummer des verwendeten Sensors
%     (Zeichenkette), Spalte sieben enthlt den Kalibrierwert in mV je EU
%     (Zahl) hier wird im Falle eines Audio-Devices der Skalierungsfaktor
%     eingerechnet, Spalte acht, neun und zehn enthalten die Koordinaten
%     X,Y,Z des Messpunktes, Spalte elf gibt an ob der Messkanal eine
%     Referenz (Wert = 1) oder keine Referenz (Wert = 0) darstellt, die
%     letzte Spalte (zwlf) enthlt die Angabe um was fr einen Kanaltyp es
%     sich handelt. Hierbei steht ai fr Analog-Input, ao fr
%     Analog-Output, ci fr Counter-Input und co fr Counter-Output.
%     Weitere Kanaltypen sind mglich. Diese mssen sich jedoch bei der
%     Nomenklatur an die vorgegebene Zeichenlnge von zwei halten. Die
%     Angaben erfolgen jeweils derart, wie es die Befehle
%     addAnalogInputChannel bzw. add AudioInputChannel erwarten.
% 
%     3.) Es wird das Objekt des Messgertes angelegt in messgeraet
%     gespeichert
% 
%     4.) Es wird die vorgegebene Abtasrate eingestellt, das Messgert auf
%     kontinuierliche Datenerfassung (Hintergrundoperation) gesetzt und die
%     Aktualisierungsrate (NotifyWhenDataAvailableExceeds) auf fs/2
%     vorbelegt.
% 
%     5.) Fr den Fall, dass es sich um eine Impulshammermessung handelt
%     wird eine Schlagpunktliste eingelesen. Der Dateiname der
%     Schlagpunktliste muss sich in handles.meta.schlagpunkte befinden
%
%%
%   nderungsliste:
%
%   nderung vom 02. Mai 2017 - Armin Rohnen
%   Anpassung an die Anforderungen fr die Impulshammermessung
%   
%   nderung vom 05. Mai 2017 - Armin Rohnen
%   Anpassung an directsound hinzu
%   Setup-Datei und Schlagpunkte-Datei mssen im angelegten Ordner 
%   <handles.meta.ordnername> abgelegt sein
%--------------------------------------------------------------------------
%% Typ, Abtastrate,Pretrigger und Frequenzauflsung auslesen
delimiter = ';';
startRow = 2;
endRow = 2;
formatSpec = '%s%f%f%f%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%[^\n\r]';
filename = ['./' handles.meta.ordnername '/' handles.meta.setupfile];
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, endRow-startRow+1, 'Delimiter', delimiter, 'HeaderLines', startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
fclose(fileID);

geraetetyp = cell2mat(dataArray{1,1}(1,1));             % In der zweiten Zeile der SETUP-Datei
fs = dataArray{1,2};                                    % sind der Gertetyp, Abtastrate, Pretrigger 
pre = dataArray{1,3};                                   % und Frequenauflsung hinterlegt
df = dataArray{1,4};

%% Neue Session mit Messgert
if geraetetyp == 'ni'
    messgeraet = daq.createSession(geraetetyp);
end;

if geraetetyp == 'au'
    messgeraet = daq.createSession('directsound');
end;

messgeraet.Rate = fs;
fs = messgeraet.Rate;
messgeraet.IsContinuous = true;                 % continuierliche Messung
messgeraet.NotifyWhenDataAvailableExceeds = ceil(fs);
                                               % Messdatenpuffer (Aktualisierungsrate) 
                                               % auf 1/df setzen
%% Messpunkte einlesen
startRow = 5;
formatSpec = '%s%s%s%s%s%s%s%s%s%s%s%s%s%s%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
fclose(fileID);

%% Messpunkte definieren
for mp=1:length(dataArray{1,1})

    messbereich = dataArray{1,3}{mp,1};
    name = dataArray{1,5}{mp,1};
    sensor = dataArray{1,6}{mp,1};
    EU = dataArray{1,7}{mp,1};
    kalibrierwert = dataArray{1,8}(mp,1);
    kalibrierwert_unit = dataArray{1,9}{mp,1};
    koord_X = dataArray{1,10}(mp,1);
    koord_Y = dataArray{1,11}(mp,1);
    koord_Z = dataArray{1,12}(mp,1);
    referenz = dataArray{1,13}(mp,1);
    signal = dataArray{1,14}(mp,1);
    
    messpunkt(mp).messbereich = str2num(messbereich);
    messpunkt(mp).name = name;
    messpunkt(mp).sensor = sensor;
    messpunkt(mp).EU = EU;
    messpunkt(mp).kalibrierwert = str2num(kalibrierwert{1,1});
    messpunkt(mp).kalibrierwert_unit = kalibrierwert_unit;
    messpunkt(mp).koord_X = str2num(koord_X{1,1});
    messpunkt(mp).koord_Y = str2num(koord_Y{1,1});
    messpunkt(mp).koord_Z = str2num(koord_Z{1,1});
    messpunkt(mp).referenz = str2num(referenz{1,1});
    messpunkt(mp).signal = signal{1,1};

    %% Input-Channel Messgert
    if geraetetyp == 'ni'
        if messpunkt(mp).signal == 'ai'                         % Analoginput
            addAnalogInputChannel(messgeraet, dataArray{1,1}{mp,1}, dataArray{1,2}{mp,1}, dataArray{1,4}{mp,1}); 
        end;
        if messpunkt(mp).signal == 'ao'                         % Analogoutput
            addAnalogOutputChannel(messgeraet, dataArray{1,1}{mp,1}, dataArray{1,2}{mp,1}, dataArray{1,4}{mp,1}); 
        end;
        if messpunkt(mp).signal == 'ci'                         % Counter Input
            addCounterInputChannel(messgeraet, dataArray{1,1}{mp,1}, dataArray{1,2}{mp,1}, dataArray{1,4}{mp,1}); 
        end;
        if messpunkt(mp).signal == 'co'                         % Counter Output
            addCounterOutputChannel(messgeraet, dataArray{1,1}{mp,1}, dataArray{1,2}{mp,1}, dataArray{1,4}{mp,1}); 
        end;
    end;
    
    if geraetetyp == 'au'                                       % Segment fr AUDIO-INPUT
        if messpunkt(mp).signal == 'ai'                         % Analoginput
            addAudioInputChannel(messgeraet, dataArray{1,1}{mp,1}, dataArray{1,2}{mp,1});

        end;
    end;
   
end;

%% Schlagpunkte einlesen
filename = ['./' handles.meta.ordnername '/' handles.meta.schlagpunktfile];
if(exist(filename) == 2)
    delimiter = ';';
    startRow = 2;
    formatSpec = '%s%s%s%s%s%s%[^\n\r]';
    fileID = fopen(filename,'r');
    dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
    fclose(fileID);
    
    for sp=1:length(dataArray{1,1})
        schlagpunkt(sp).name = cell2mat(dataArray{1,1}(sp,1));
        schlagpunkt(sp).kurz = cell2mat(dataArray{1,2}(sp,1));
        schlagpunkt(sp).X = str2num(cell2mat(dataArray{1,3}(sp,1)));
        schlagpunkt(sp).Y = str2num(cell2mat(dataArray{1,4}(sp,1)));
        schlagpunkt(sp).Z = str2num(cell2mat(dataArray{1,5}(sp,1))); 
    end;
    
else
    schlagpunkt(1).name = 'Keine Schlagpunkte';
end;

%%
% Funktionsende
%
end
