function varargout = doku(varargin)
% DOKU MATLAB code for doku.fig
%      DOKU, by itself, creates a new DOKU or raises the existing
%      singleton*.
%
%      H = DOKU returns the handle to a new DOKU or the handle to
%      the existing singleton*.
%
%      DOKU('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DOKU.M with the given input arguments.
%
%      DOKU('Property','Value',...) creates a new DOKU or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before doku_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to doku_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help doku

% Last Modified by GUIDE v2.5 18-Oct-2018 13:40:14

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @doku_OpeningFcn, ...
                   'gui_OutputFcn',  @doku_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before doku is made visible.
function doku_OpeningFcn(hObject, eventdata, handles, varargin)
% Choose default command line output for doku
handles.output = hObject;

%
% Flags zur Steuerung des Ablaufs
% hierdurch wird festgestellt, ob alle zwingend erforderlichen
% Parameter eingegeben wurden
%

handles.setup = false;              % Setup
handles.datenablage = false;        % Datenablage
handles.datumok = false;            % Datumseingabe
handles.meta.zyklus = 'standard';   % Vorbelegung der Messzyklusliste

% Update handles structure
guidata(hObject, handles);
% modal: blockiert alle anderen Fenster
%set( hObject, 'WindowStyle', 'modal' );
% Startet das Warten, bis uiresume aufgerufen wird
uiwait( handles.figure1 );


% --- Outputs from this function are returned to the command line.
function varargout = doku_OutputFcn(hObject, eventdata, handles) 
% Get default command line output from handles structure
% varargout{1} = handles.output;
% jetzt erst wird die figure gelscht und das Programm beendet
% dadurch wird auch die Blockade der anderen Fenster aufgehoben
% delete( handles.figure1 );


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
uiresume( handles.figure1 );

function edit1_Callback(hObject, eventdata, handles)
%
% Vorname Prfer
%

handles.meta.vornamePruefer = get( hObject, 'String' );
set(handles.status, 'String', 'Vorname Prfer');
guidata( hObject, handles );

function edit1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit2_Callback(hObject, eventdata, handles)
%
% Name Prfer
%

handles.meta.namePruefer = get( hObject, 'String' );
set(handles.status, 'String', 'Name Prfer');
guidata( hObject, handles );

function edit2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit3_Callback(hObject, eventdata, handles)
%
% Vorname Auftraggeber
%

handles.meta.vornameAuftrag = get( hObject, 'String' );
set(handles.status, 'String', 'Vorname Auftraggeber');
guidata( hObject, handles );

function edit3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit4_Callback(hObject, eventdata, handles)
%
% Name Auftraggeber
%

handles.meta.nameAuftrag = get( hObject, 'String' );
set(handles.status, 'String', 'Name Auftraggeber');
guidata( hObject, handles );

function edit4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit5_Callback(hObject, eventdata, handles)
%
% Firma Auftraggeber
%

handles.meta.firmaAuftrag = get( hObject, 'String' );
set(handles.status, 'String', 'Firma Auftraggeber');
guidata( hObject, handles );

function edit5_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit6_Callback(hObject, eventdata, handles)
%
% Datum
%

handles.meta.datum = regexprep(get( hObject, 'String' ),' ','');
if length(handles.meta.datum) > 7
    set(handles.status, 'String', 'Datum');
    handles.datumok = true;
else
    handles.datumok = false;
    set(handles.status, 'String', 'Datumseingabe nicht korrekt');
end;

guidata( hObject, handles );

function edit6_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit7_Callback(hObject, eventdata, handles)
%
% Objektbeschreibung
%

handles.meta.objekt = get( hObject, 'String' );
if length(handles.meta.objekt) > 20
    set(hObject, 'String', handles.meta.objekt(1:15));
    set(handles.status, 'String', 'Objektbeschreibung auf 15 Zeilen reduziert');
else
    set(handles.status, 'String', 'Objektbeschreibung');
end;
guidata( hObject, handles );

function edit7_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit8_Callback(hObject, eventdata, handles)
%
% Versuchsbeschreibung
%

handles.meta.versuch = get( hObject, 'String' );
if length(handles.meta.versuch) > 20
    set(hObject, 'String', handles.meta.versuch(1:15));
    set(handles.status, 'String', 'Versuchsbeschreibung auf 15 Zeilen reduziert');
else
    set(handles.status, 'String', 'Versuchsbeschreibung');
end;
guidata( hObject, handles );

function edit8_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit10_Callback(hObject, eventdata, handles)
%
% Dateiname
%

handles.meta.dateiname = regexprep(get( hObject, 'String' ),' ','');
if length(handles.meta.dateiname) > 4
    if exist(handles.meta.dateiname)>0
        handles.datenablage = false;
        set(handles.status, 'String', 'Dateiname bereits vorhanden');
        handles.meta.dateiname = '';
    else
        handles.datenablage = true;
        set(handles.status, 'String', 'Dateiname OK');
    end;
else
    handles.datenablage = false;
    set(handles.status, 'String', 'Dateiname zu kurz bzw. falsch');    
end;
guidata( hObject, handles );



% --- Executes during object creation, after setting all properties.
function edit10_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function setupfilebutton_Callback(hObject, eventdata, handles)
% bergeben der Variablen messgeraet, fs und messpunkt an handles
handles.meta.setupfile = uigetfile({'*.csv;','Setup Files (*.csv)'});

if length(handles.meta.setupfile) > 4
    set(handles.spfilename, 'String', handles.meta.setupfile);
    handles.setup = true;
else
    set(handles.spfilename, 'String', 'kein Setup ausgewhlt');
    handles.setup = false;
end;

guidata(hObject,handles);   % nderungen aktiv setzen


function abbrechenbutton1_Callback(hObject, eventdata, handles)
%
% Abbruch
%
set(handles.status, 'String', 'Doku-GUI wird geschlossen'); 
guidata(hObject,handles);   % nderungen aktiv setzen
delete( handles.figure1 );

% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%
% Weiter -> Messdurchfhrung
%
% wenn ein SETUP gewhlt ist, ein Datum eingegeben wurde und ein Dateiname
% existiert

if handles.setup && handles.datumok && handles.datenablage
    setappdata(0,'metadaten',handles.meta);     % Metadaten bergeben
    mkdir(handles.meta.dateiname);              % Anlegen Messverzeichnis
    ziel = ['./' handles.meta.dateiname '/doku.mat'];
    metadaten = handles.meta;
    save(ziel,'metadaten');                     % Ablegen Metadaten in Messverzeichnis
    ziel = ['./' handles.meta.dateiname];
    quelle = ['./SETUP/' handles.meta.setupfile];
    copyfile(quelle, ziel);     % Setup in Messverzeichnis kopieren
    messung;                                    % Mess-GUI aufrufen
    delete( handles.figure1 );                  % Doku-GUI schlieen
else
    set(handles.status, 'String', 'Messen nicht mglich, es fehlen Eingaben');
    guidata(hObject,handles);   % nderungen aktiv setzen
end;


% --- Executes on button press in messzyklus.
function messzyklus_Callback(hObject, eventdata, handles)
% hObject    handle to messzyklus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.meta.zyklus = uigetfile({'*.csv;','Setup Files (*.csv)'});

if length(handles.meta.zyklus) > 4
    set(handles.text14, 'String', handles.meta.zyklus);
else
    set(handles.text14, 'String', 'keine Meszyklen ausgewhlt');
end;

guidata(hObject,handles);   % nderungen aktiv setzen
