function dispData(src, event, handles, hObject)

global fs messpunkt analyseChan statusMessen analyse freqSkale windowname aktMessung;
global startTime store overloadChan;

    time = event.TimeStamps;
    data = event.Data*1000;
    
    for chan=1:length(messpunkt)
        
       data(:,chan) = data(:,chan)/messpunkt(chan).kalibrierwert;
       data_to_plot = max(data(:,chan));
       ymaxwert = messpunkt(chan).messbereich/messpunkt(chan).kalibrierwert;
      
       if data_to_plot > ymaxwert           % Overloaddetetction
           overload = true;
           overloadChan(chan,1) = 1;
       else
           overload = false;
       end;
       
       yminwert = 0;
       xmaxwert = 2;
       xminwert = 0;
       
       switch chan
          case 1
             ax = handles.axes1;
             textfeld = handles.edit1;
             ovlfeld = handles.ovl1;
          case 2
             ax = handles.axes2;
             textfeld = handles.edit2;
             ovlfeld = handles.ovl2;
          case 3
             ax = handles.axes3;  
             textfeld = handles.edit3;
             ovlfeld = handles.ovl3;
          case 4
             ax = handles.axes4;
             textfeld = handles.edit4;
             ovlfeld = handles.ovl4;
          case 5
             ax = handles.axes5;
             textfeld = handles.edit5;
             ovlfeld = handles.ovl5;
          case 6
             ax = handles.axes6;
             textfeld = handles.edit6;
             ovlfeld = handles.ovl7;
          case 7
             ax = handles.axes7;
             textfeld = handles.edit7;
             ovlfeld = handles.ovl7;
          case 8
             ax = handles.axes8;
             textfeld = handles.edit8;
             ovlfeld = handles.ovl8;
          case 9
             ax = handles.axes9;
             textfeld = handles.edit9;
             ovlfeld = handles.ovl9;
          case 10
             ax = handles.axes10;
             textfeld = handles.edit10;
             ovlfeld = handles.ovl10;
          case 11
             ax = handles.axes11;
             textfeld = handles.edit11;
             ovlfeld = handles.ovl11;
          case 12
             ax = handles.axes12;
             textfeld = handles.edit12;
             ovlfeld = handles.ovl12;
          case 13
             ax = handles.axes13;
             textfeld = handles.edit13;
             ovlfeld = handles.ovl13;
          case 14
             ax = handles.axes14;
             textfeld = handles.edit14;
             ovlfeld = handles.ovl14;
          case 15
             ax = handles.axes15;
             textfeld = handles.edit15;
             ovlfeld = handles.ovl15;
          case 16
             ax = handles.axes16;
             textfeld = handles.edit16;
             ovlfeld = handles.ovl16;
          case 17
             ax = handles.axes17;
             textfeld = handles.edit17;
             ovlfeld = handles.ovl17;
          case 18
             ax = handles.axes18;
             textfeld = handles.edit18;
             ovlfeld = handles.ovl18;
          case 19
             ax = handles.axes19;
             textfeld = handles.edit19;
             ovlfeld = handles.ovl19;
          case 20
             ax = handles.axes20;
             textfeld = handles.edit20;
             ovlfeld = handles.ovl20;
          case 21
             ax = handles.axes21;
             textfeld = handles.edit21;
             ovlfeld = handles.ovl21;
          case 22
             ax = handles.axes22;
             textfeld = handles.edit22;
             ovlfeld = handles.ovl22;
          case 23
             ax = handles.axes23;
             textfeld = handles.edit23;
             ovlfeld = handles.ovl23;
          case 24
             ax = handles.axes24;
             textfeld = handles.edit24;
             ovlfeld = handles.ovl24;
          case 25
             ax = handles.axes25;
             textfeld = handles.edit25;
             ovlfeld = handles.ovl25;
          case 26
             ax = handles.axes26;
             textfeld = handles.edit26;
             ovlfeld = handles.ovl26;
          case 27
            ax = handles.axes27;
            textfeld = handles.edit27;
            ovlfeld = handles.ovl27;
          case 28
             ax = handles.axes28;
             textfeld = handles.edit28;
             ovlfeld = handles.ovl28;
          case 29
             ax = handles.axes29;
             textfeld = handles.edit29;
             ovlfeld = handles.ovl29;
          case 30
             ax = handles.axes30;
             textfeld = handles.edit30;
             ovlfeld = handles.ovl30;
          case 31
             ax = handles.axes31;
             textfeld = handles.edit31;
             ovlfeld = handles.ovl31;
          case 32
             ax = handles.axes32;
             textfeld = handles.edit32;
             ovlfeld = handles.ovl32;
          otherwise
             disp(' ')
       end;
       
       stem(ax, data_to_plot, ...
           'LineWidth', 10, ...
           'MarkerSize', 10);
       set(ax,'XTickLabel',{});
       set(ax,'YTickLabel',{});
       axis(ax,[xminwert xmaxwert yminwert ymaxwert]);
       
       set(textfeld, 'String', num2str(messpunkt(chan).messbereich/1000));
       
       if overload
           set(ovlfeld, 'String', 'OVL');
       end;
   end;
   
   xminwert = 0;                        % erster Zeitwert
   xmaxwert = time(end,1)-time(1,1);    % letzter Zeitwert
   ymaxwert = messpunkt(analyseChan).messbereich/messpunkt(analyseChan).kalibrierwert;
   
   switch analyse
       case 1               % Signalanalyse Zeitsignal
           plot(handles.axes33,time-time(1,1), data(:,analyseChan)/messpunkt(chan).kalibrierwert);
           axis(handles.axes33,[xminwert xmaxwert -ymaxwert ymaxwert]);
           
       case 2               % Signalanalyse RMS
           wl = ceil(fs/1000);
           [yupper,ylower] = envelope(data(:,analyseChan)/messpunkt(chan).kalibrierwert,wl,'rms');
           plot(handles.axes33,time-time(1,1), yupper);
           axis(handles.axes33,[xminwert xmaxwert 0 ymaxwert]);
           
       case 3               % Signalanalyse Spektrum
           daten_f_ft = data(:,analyseChan)/messpunkt(chan).kalibrierwert;
           nfft = length(daten_f_ft);                                    
                                                    % Daten mit WINDOW-Funktion gewichten
           if windowname == 'hann'                  % Pegelkorrigirtes Hanning-Window
               window = hann(nfft)*nfft/sum(hann(nfft));
               daten_f_ft = daten_f_ft.*window;
           end;
           if windowname == 'hann'                  % Pegelkorrigirtes Flattop-Window
               window = flattopwin(nfft)*nfft/sum(flattopwin(nfft));
               daten_f_ft = daten_f_ft.*window;
           end;
           
           betrag = 2*abs(fft(daten_f_ft))/nfft;
           plot(handles.axes33,fs * (0:(nfft/2-1)) / nfft, betrag(1:nfft/2));
           axis(handles.axes33,[0 fs/freqSkale 0 inf]);
   end;
   
   switch statusMessen                            
       case 4       % Messung wurde beendet
           aktMessung.data = vertcat(aktMessung.data, data);
           time = time-startTime;
           aktMessung.time = vertcat(aktMessung.time, time);
           set(handles.aktzeit, 'String', num2str(aktMessung.time(end,1)));
           statusMessen = 1;
           store = true;
           set(handles.status, 'String', 'Messung beendet und kann nun gespeichert werden');
    
       case 3       % Messung luft
           aktMessung.data = vertcat(aktMessung.data, data);
           time = time-startTime;
           aktMessung.time = vertcat(aktMessung.time, time);
           set(handles.aktzeit, 'String', num2str(aktMessung.time(end,1)));
           
           if (aktMessung.time(end,1) >= handles.meta.messzeit)
               statusMessen = 1;
               store = true;
               set(handles.status, 'String', 'Messung beendet und kann nun gespeichert werden');
           end;
           
       case 2       % Messung wurde gestartet
           aktMessung.data = data;
           startTime = time(1,1);
           aktMessung.time = time-startTime;
           statusMessen = 3;
           set(handles.aktzeit, 'String', num2str(aktMessung.time(end,1)));
           set(handles.status, 'String', 'Messung');
   end;
% end function
end